<?php

/*

     Diese Datei ist Teil des namenlosen Steinchenspiels, 
    (c) 2004 Mattias Schlenker fr LINUX INTERN

    c.php enthlt das eigentliche Spiel
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
	// Bevor eine Session initialisert wird, mssen Klassendefinitionen
	// geladen werden!
	include "spielfeld.php";	
	session_start(); 
	
	// Auslesen der per URL bergebenen Variablen:
	$x = $_GET["x"];
	$y = $_GET["y"];
	$restart = $_GET["restart"];	
	
	// Die Session-Variablen sind noch nicht gesetzt oder es wurde
	// explizit ein Neustart veranlasst. In diesem Fall mu ein 
	// Spielfeld initialisiert werden
	if ($restart > 0 || !isset($_SESSION["punkte"])) {
		$_SESSION["punkte"] = 0;
		$_SESSION["spielfeld"] = new SpielFeld (25, 9);
	// Die Session-Variablen konnten ausgelesen werden, wir nehmen 
	// an, da ein Klick ins Feld erfolgte (ob dieser zulssig ist, 
	// ermittelt das Spielfeld-Objekt) 
	} else {
		$_SESSION["punkte"] += $_SESSION["spielfeld"]->klickAn($x, $y);
	}
?>
<html>
	<head>
		<title>Steinchenspiel</title>
		<link rel="stylesheet" type="text/css" href="default.css" />
	</head>
	<body>
		<h2>Steinchenspiel</h2>
		<?php

		// Das Spielfeld wird immer angezeigt		
		$_SESSION["spielfeld"]->zeigeSpielfeld();
		
		?>
		<p>Punkte: 
		<?php
		
		// Auch die Punktzahl wird immer angezeigt
		echo $_SESSION["punkte"];
		
		?>
		</p>
		<p>
		<?php
		
		// Falls das Feld nicht mehr spielbar ist, soll der 
		// Spieler darauf hingewisesn werden...
		if (!$_SESSION["spielfeld"]->feldSpielbar()) {
			echo "Das Spiel ist beendet!";
		}
		
		?>
		<a href="c.php?restart=1">Neues Spiel?</a> <a href="highscore.php">Highscores</a>
		</p>
		<p>
		<?php
		
		// ...und ein Eingabefeld fr die Highscoreliste prsentiert bekommen:
		if (!$_SESSION["spielfeld"]->feldSpielbar()) {
			echo "<h3>Namen zur Highscoreliste hinzufgen</h3>\n";
			echo "<form method=\"POST\" action=\"highscore.php\">\n".
				"<input type=\"text\" size=\"40\" maxsize=\"80\" name=\"name\" />".
				"<input type=\"submit\">".
				"</form>";
		}
		
		?>
		</p>
	</body>
</html>
