<?php

/*

    Diese Datei ist Teil des namenlosen Steinchenspiels, 
    (c) 2004 Mattias Schlenker fr LINUX INTERN

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

include "spielfeld.php";	
session_start(); 

// Herstellen der Datenbankverbindung zu einer SQLite-Datenbank
$dbdatei = "/tmp/highscores.sqlite";
$db = sqlite_open($dbdatei, 0666, $err);
$tstamp = time();

// Auch dieses Script hat Zugriff auf die in c.php gesetzte Session

// Falls vorhanden lesen wir die Punktzahl aus der Session aus und
// ermitteln den Namen des Spielers oder der Spielerin aus den 
// POST-Variablen. Beide fgen wir in die Datenbank ein

if (isset($_SESSION["punkte"]) && sizeof($_POST["name"]) > 0) {
	$abfrage = "INSERT INTO highscores (name, punkte, zeit) VALUES (\"".
		sqlite_escape_string($_POST["name"])."\", ".(int)$_SESSION["punkte"].", ".$tstamp.")";
	if ( !sqlite_query($db, $abfrage) )
   	// Falls ein Fehler passiert, geben wir ihn aus:
   		die(sqlite_last_error($db).': '.
       		sqlite_error_string(sqlite_last_error($db)));
	unset($_SESSION["punkte"]);
	unset($_SESSION["spielfeld"]);
}
?>
<html>
	<head>
		<title>Steinchenspiel Highscores</title>
		<link rel="stylesheet" type="text/css" href="default.css" />
	</head>
	<body>
		<h2>Top 10 der letzten 24 Stunden</h2>
		<p><a href="c.php">Zum Spiel</a></p>
		<table class="highscores">
		<tr class="header">
			<td>Platz</td><td>Punkte</td><td>Name</td>
		</tr>
		<?php
		
		// Abfrage der Highscoreliste (Top 10) der letzten 24 Stunden
		$abfrage = "SELECT punkte, name, zeit FROM highscores WHERE zeit > ".
			($tstamp - 24*60*60)." ORDER BY punkte DESC LIMIT 10"; 
		$q = sqlite_query($db, $abfrage);
		if ($q) {
			// Zhler fr Platzierung
			$i = 0;
			// Das Ergebnis wird nun zeilenweise ausgegeben:
    			while ($r = sqlite_fetch_array($q, SQLITE_NUM)) {
        			list($punkte, $name, $zeit) = $r;
        			echo "<tr><td>".++$i."</td><td>".$punkte."</td><td>".$name."</td></tr>";
				echo "<!-- age ".($tstamp - $zeit)."s -->\n";
    			}
		}
		
		?>
		</table>
		<h2>Alltime Highscores</h2>
		<p><a href="c.php">Zum Spiel</a><p>
		<table class="highscores">
		<tr class="header">
			<td>Platz</td><td>Punkte</td><td>Name</td>
		</tr>
		<?php
		
		// Abfrage der Highscoreliste (Top 100) aller Zeiten
		$abfrage = "SELECT punkte, name FROM highscores ORDER BY punkte DESC LIMIT 100"; 
		
		$q = sqlite_query($db, $abfrage);
		if ($q) {
			// Zhler fr Platzierung
			$i = 0;
			// Das Ergebnis wird nun zeilenweise ausgegeben:
    			while ($r = sqlite_fetch_array($q, SQLITE_NUM)) {
        			list($punkte, $name) = $r;
        			echo "<tr><td>".++$i."</td><td>".$punkte."</td><td>".$name."</td></tr>";
    			}
		}
		
		?>	
		</table>
	</body>
</html>