<?php

/*
    Diese Datei ist Teil des namenlosen Steinchenspiels, 
    (c) 2004 Mattias Schlenker fr LINUX INTERN
    
    spielfeld.php enthlt die Logik fr das Spielfeld
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	

*/

class SpielFeld {
	private $hoehe;
	private $breite;
	private $gitter = array();
	
	// Konstruktor des Spielfelds -- Jeder Zelle im Gitter wird eine 
	// zufllig ausgewhlte Farbe 0, 1, 2 zugewisesen
	
	public function __construct ($x, $y) {
		$this->hoehe = $y;
		$this->breite = $x;
		for ($i = 0; $i < $this->breite; $i++) {
			$this->gitter[$i] = array();
			for ($j = 0; $j < $this->hoehe; $j++) {
				$this->gitter[$i][$j] = rand(0,100000) % 3;;
			}
		}
	}
	
	// ermittelt, ob ein Feld erlaubt ist, d.h. ob es im Gitter liegt
	// und noch einen Stein enthlt
	
	private function erlaubt ($x, $y) {
		return (isset($this->gitter[$x][$y]) &&
			$x > -1 && $y > -1 &&
			$x < $this->breite && $y < $this->hoehe);
	}
	
	// ein Feld ist immer dann klickbar, wenn es nicht nur erlaubt ist, 
	// sondern auch einen gleichfarbigen Nachbarn hat
	
	private function klickBar ($x, $y) {
		$farbe = $this->gitter[$x][$y];
		if (!$this->erlaubt($x, $y)) {
			return false;
		}
		return (
			($this->erlaubt($x, $y-1) &&
			$this->gitter[$x][$y-1] == $farbe) ||
			
			($this->erlaubt($x, $y+1) &&
			$this->gitter[$x][$y+1] == $farbe) ||
			
			($this->erlaubt($x-1, $y) &&
			$this->gitter[$x-1][$y] == $farbe) ||
			
			($this->erlaubt($x+1, $y) &&
			$this->gitter[$x+1][$y] == $farbe)
		);
	}
	
	// Die ffentliche Funktion klickAn macht nichts anderes als
	// das Durchlaufen ber Nachbarn zu veranlassen, das Feld
	// ineinanderfallen zu lassen und die Punkte zu berechnen.
	
	public function klickAn ($x, $y) {
		if ($this->erlaubt($x, $y) && $this->klickBar($x, $y)) {
			$kugeln = $this->laufDurch($x, $y);
			$this->kollabiere();
			$punkte = $kugeln * ($kugeln + 1) / 2;
			if ($this->breite < 1) {
				$punkte += 500;
			}
			return $punkte;
		} else {
			return 0;
		}
	}
	
	// Wird ein (klickbares) Feld angeklickt, so wird die dort
	// befindliche Kugel entfernt und die Funktion rekursiv auf 
	// allen gleichfarbigen Nachbarn aufgerufen. Rckgabewert
	// ist die Anzahl der entfernten Kugeln.
	
	private function laufDurch ($x, $y) {
		$kugeln = 1;
		$farbe = $this->gitter[$x][$y];
		unset($this->gitter[$x][$y]);
		// unterer Nachbar	
		if ($this->erlaubt($x, $y-1) &&
		$this->gitter[$x][$y-1] == $farbe) {
			$kugeln += $this->laufDurch($x, $y-1);	
		}
		// oberer Nachbar
		if ($this->erlaubt($x, $y+1) &&
		$this->gitter[$x][$y+1] == $farbe) {
			$kugeln += $this->laufDurch($x, $y+1);	
		}
		// linker Nachbar
		if ($this->erlaubt($x-1, $y) &&
		$this->gitter[$x-1][$y] == $farbe) {
			$kugeln += $this->laufDurch($x-1, $y);	
		}
		// rechter Nachbar
		if ($this->erlaubt($x+1, $y) &&
		$this->gitter[$x+1][$y] == $farbe) {
			$kugeln += $this->laufDurch($x+1, $y);	
		}
		return $kugeln;
	}
	
	// Hier lassen wir das Feld einstrzen: von oben fallen
	// die Kugeln herunter und schlieen Lcken, leere Spalten
	// werden von rechts aufgefllt.
	
	private function kollabiere () {
		$hilfsfeld = array();
		$neuehoehe = 0;
		// Jede Spalte...
		for ($i=0; $i < $this->breite; $i++) {
			$hilfsarray = array();
			// Jedes Element in dieser Spalte...
			for ($j=0; $j < $this->hoehe; $j++) {
				if (isset($this->gitter[$i][$j])) {
					// befindet sich noch eine Kugel an dieser
					// Stelle, landet sie im Hilfsarray
					array_push($hilfsarray, $this->gitter[$i][$j]);
				}
			}
			// Ist der Hilfsarray nicht leer, wird er zum Gitter 
			// hinzugefgt
			if (isset($hilfsarray[0])) {
				array_push($hilfsfeld, $hilfsarray);
				$neuehoehe = max($neuehoehe, sizeof($hilfsarray));
			}
		}
		// Hilfsfeld wird ber das alte Gitter kopiert
		$this->gitter = $hilfsfeld;
		// Breite und Hhe werden angepasst
		$this->breite = sizeof($hilfsfeld);
		$this->hoehe = $neuehoehe;
	}  
	
	// Ermittelt, ob ein Feld noch spielbar ist. Bei der ersten gefundenen 
	// Kugel wird "wahr" zurckgegeben.
	
	public function feldSpielbar () {
		for ($i=0; $i < $this->breite; $i++) {
			for ($j=0; $j < $this->hoehe; $j++) {
				if ($this->klickBar($i, $j)) {
					return true;
				}
			}
		}	
		return false;
	}

	// Erstellt eine HTML-Tabelle mit Links aus dem Spielfeld.
	// Im Gegensatz zu allen anderen Funktionen mssen wir hier
	// erst zeilen- und dann Spaltenweise vorgehen.
	// Die ALT-Attribute werden so gesetzt, da das Spiel auch 
	// in Lynx spielbar ist.
	
	public function zeigeSpielfeld () {
		$alt = array("o", "x", "+");
		echo "<table class=\"spielfeld\">\n";
		for ($i = $this->hoehe - 1; $i >= 0; $i--) {
			echo "<tr>\n";
			for ($j = 0; $j < $this->breite; $j++) {
				echo "<td>";
				if ($this->klickBar($j, $i)) {
					echo "<a href=\"c.php?x=".$j."&y=".$i."\">";
				}
				if (isset($this->gitter[$j][$i])) {
					$farbe = $this->gitter[$j][$i];
					echo "<img src=\"".(int)$farbe.".png\" ".
						"alt=\"".$alt[(int)$farbe]."\"/>";
				}
				if ($this->klickBar($j, $i)) {
					echo "</a>";
				}
				echo "</td>\n";
			}
			echo "</tr>\n\n";
		}
		echo "</table>\n";
	}
}

?>